///////////////////////////////////////////////////////////////////////////////
// Quake3.cpp
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2008, Joe Riedel
// All rights reserved.
//
// Redistribution and use in source and binary forms, 
// with or without modification, are permitted provided 
// that the following conditions are met:
//
// Redistributions of source code must retain the above copyright notice, 
// this list of conditions and the following disclaimer. 
//
// Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation and/or 
// other materials provided with the distribution. 
//
// Neither the name of the <ORGANIZATION> nor the names of its contributors may be 
// used to endorse or promote products derived from this software without specific 
// prior written permission. 
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//
// IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
// OF SUCH DAMAGE.
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Quake3.h"

///////////////////////////////////////////////////////////////////////////////
// CQuake3Game
///////////////////////////////////////////////////////////////////////////////

const char *CQuake3Game::Name()
{
	return "Quake3";
}

void CQuake3Game::GetExportFile(const char *filename, char *buff, int buffSize)
{
	strcpy(buff, GameDir());
	strcat(buff, "\\baseq3\\maps\\");
	strcat(buff, filename);
	StrSetFileExtension(buff, "map");
}

CPluginFileExport *CQuake3Game::NativeMapExporter()
{
	return new CQuake3Map();
}

CPluginFileExport *CQuake3Game::FileExporter(int i)
{
	switch (i)
	{
	case 0: return new CQuake3Map();
	}
	return 0;
}

const char *CQuake3Game::PakType(int i)
{
	switch (i)
	{
	case 0: return "pk3";
	}
	return 0;
}

CTextureFactory *CQuake3Game::CreatePakFile()
{
	return new CQuake3Pak();
}

CQuakeUserData *CQuake3Game::CreateUserData(CTreadDoc *doc)
{
	return new CQuake3UserData(doc, this);
}

void CQuake3Game::InitializeToolsList(QuakeToolsList &tools)
{
	tools.push_back(LoadToolOpts(CQuakeTool("QBsp"), "9:base:quake3.opts"));
	tools.push_back(LoadToolOpts(CQuakeTool("QVis"), "9:base:quake3.opts"));
	tools.push_back(LoadToolOpts(CQuakeTool("QRad"), "9:base:quake3.opts"));
	tools.push_back(LoadToolOpts(CQuakeTool("Bots"), "9:base:quake3.opts"));
}

void CQuake3Game::RunMapCompile(const char *inpath, QuakeToolsList &tools, CTreadDoc *doc, bool runGame)
{
	ExportShaderList(doc);
	CQuakeGame::RunMapCompile(inpath, tools, doc, runGame);

	//CString str = inpath;
	//char mapname[1024];
	//char mappath[1024];
	//strcpy(mappath, inpath);
	//Sys_GetFilename(mappath, mapname, 1024);
	//str.MakeLower();
	//if (str.Find("quake2") == -1)
	//{
	//	doc->WriteToCompileWindow("Non standard Q2 directory detected, building in temp directory for tools compatibility.\n");

	//	// the hard way...
	//	char temp[1024];
	//	
	//	// export colormap.pcx
	//	GetTempPath(1024, temp);
	//	strcat(temp, "quake2\\baseq2\\pics\\");
	//	CreateDirectoryPathNative(temp);
	//	strcat(temp, "colormap.pcx");
	//	Sys_WriteFile(temp, s_q2colorMap.Data(), s_q2colorMap.Length());
	//	
	//	// export .wal files
	//	GetTempPath(1024, temp);
	//	strcat(temp, "quake2\\baseq2\\textures");
	//	CreateDirectoryPathNative(temp);
	//	ExportTextures(temp, doc);
	//	
	//	GetTempPath(1024, temp);
	//	strcat(temp, "quake2\\baseq2\\maps\\");
	//	CreateDirectoryPathNative(temp);
	//	strcat(temp, mapname);
	//	CopyFileA(mappath, temp, FALSE);

	//	//
	//	// NOTE: this run function only kicks off a thread.
	//	//
	//	CQuakeGame::RunMapCompile(temp, tools, doc, runGame);
	//}
	//else
	//{
	//	char path[1024];
	//	Sys_GetDirectory(mappath, path, 1024);
	//	strcat(path, "\\..\\pics");
	//	CreateDirectoryPathNative(path);
	//	strcat(path, "\\colormap.pcx");
	//	Sys_WriteFile(path, s_q2colorMap.Data(), s_q2colorMap.Length());

	//	//
	//	// NOTE: this run function only kicks off a thread.
	//	//
	//	CQuakeGame::RunMapCompile(mappath, tools, doc, runGame);
	//}
}

void CQuake3Game::ExportShaderList(CTreadDoc *doc)
{
	CQuakeGame *game = static_cast<CQuakeGame*>(doc->GamePlugin());
	doc->WriteToCompileWindow("***************************\nExtracting PAK files\n***************************\n");
	doc->WriteToCompileWindow("export dir: %s\\baseq3\n", game->GameDir());

	char path[1024];
	strcpy(path, game->GameDir());
	strcat(path, "\\baseq3\\scripts");
	CreateDirectoryPathNative(path);

	ShaderListExportParams parms;
	strcat(path, "\\shaderlist.txt");
	parms.fp = fopen(path, "wb");
	parms.doc = doc;

	strcpy(path, game->GameDir());
	strcat(path, "\\baseq3");
	parms.baseq3 = path;

	doc->GetObjectList()->WalkList(ExportBrushShaders, &parms);
	doc->GetSelectedObjectList()->WalkList(ExportBrushShaders, &parms);

	fclose(parms.fp);
}

int CQuake3Game::ExportBrushShaders(CMapObject *obj, void *p1, void *p2)
{
	ShaderListExportParams *parms = static_cast<ShaderListExportParams*>(p1);
	CQBrush *brush = dynamic_cast<CQBrush*>(obj);
	
	if (brush)
	{
		for (int i = 0; i < brush->m_numfaces; ++i)
		{
			CShader *shader = brush->m_faces[i].p_shader;
			CQuake3ShaderTex *tex = dynamic_cast<CQuake3ShaderTex*>(shader);

			if (tex)
			{
				CQuake3Shader *shader = tex->Shader();

				if (!shader->fake)
				{
					if (parms->shaders.find((const char*)shader->file) == parms->shaders.end())
					{
						fprintf(parms->fp, "%s\n", shader->file);
						parms->shaders.insert((const char*)shader->file);
						static_cast<CQuake3Game*>(parms->doc->GamePlugin())->ExportFile(parms->doc, parms->baseq3, shader->path);
					}
				}
				
				for (StringList::iterator it = shader->maps.begin(); it != shader->maps.end(); ++it)
				{
					if (parms->files.find((const char*)*it) == parms->files.end())
					{
						parms->files.insert((const char*)*it);
						static_cast<CQuake3Game*>(parms->doc->GamePlugin())->ExportFile(parms->doc, parms->baseq3, *it);
					}
				}
			}
		}
	}

	return 0;
}

void CQuake3Game::ExportFile(CTreadDoc *doc, const char *dir, const char *file)
{
	const TextureFactoryList &tfl = GetTextureFactoryList();
	for (TextureFactoryList::const_iterator it = tfl.begin(); it != tfl.end(); ++it)
	{
		CQuake3PakBase *pak = dynamic_cast<CQuake3PakBase*>(*it);
		if (pak)
		{
			if (pak->ExportFile(doc, dir, file)) break;
		}
	}
}

void CQuake3Game::GetLeakFileName(CTreadDoc *doc, char *buff, int buffSize)
{
	doc->GetMapExportPathName(buff, buffSize);
	StrSetFileExtension(buff, "lin");
}

bool CQuake3Game::LeakTraceExists(CTreadDoc *doc)
{
	char buff[1024];
	GetLeakFileName(doc, buff, 1024);
	return Sys_FileExists(buff);
}

CQuakeCompiler *CQuake3Game::CreateCompiler(const char *filename, QuakeToolsList &tools, CTreadDoc *doc, bool runMap)
{
	return new CQuake3Compiler(filename, tools, doc, runMap);
}

///////////////////////////////////////////////////////////////////////////////
// CQuake3Compiler
///////////////////////////////////////////////////////////////////////////////

CQuake3Compiler::CQuake3Compiler(const char *filename, QuakeToolsList &tools, CTreadDoc *doc, bool runMap) :
CQuakeCompiler(filename, tools, doc, false), m_myRunMap(runMap)
{
}

void CQuake3Compiler::ThreadProc()
{
	CQuakeCompiler::ThreadProc();

	//CString str = m_realmappath;
	//str.MakeLower();
	//if (str.Find("quake2") == -1) // copy files.
	//{
	//	char temp[1024];
	//	char mappath[1024];
	//	strcpy(temp, m_filename);
	//	strcpy(mappath, m_realmappath);

	//	StrSetFileExtension(temp, "lin");
	//	StrSetFileExtension(mappath, "lin");
	//	CopyFileA(temp, mappath, FALSE);

	//	StrSetFileExtension(temp, "bsp");
	//	StrSetFileExtension(mappath, "bsp");
	//	BOOL b = CopyFileA(temp, mappath, FALSE);
	//	OS_ASSERT(b);
	//}

	if (m_myRunMap)
	{
		m_doc->WriteToCompileWindow("************\nRunning %s\n************\n", m_doc->GamePlugin()->Name());
		m_doc->GamePlugin()->RunGame(m_realmappath);
	}
}

///////////////////////////////////////////////////////////////////////////////
// CQuake3UserData
///////////////////////////////////////////////////////////////////////////////

void CQuake3UserData::MakeBrushMenu(CTreadDoc *doc)
{
	if( m_BrushMenuCreated )
		return;

	m_BrushMenu.AddMenuItem( BM_EDIT_FACES, "Edit Faces" );
	m_BrushMenu.AddMenuItem( BM_EDIT_VERTS, "Edit Verts" );
	m_BrushMenu.AddMenuItem( BM_LOCK_TEXTURE, "Lock Texture" );
	m_BrushMenu.AddMenuItem( BM_GRAB_TEXTURE, "Grab Texture" );
	m_BrushMenu.AddMenuItem( BM_APPLY_TEXTURE, "Apply Texture" );
	m_BrushMenu.AddMenuItem( BM_SELECT_ALL_WITH_TEXTURE, "Select All w/ Texture" );
//	m_BrushMenu.AddMenuItem( 15, "Edit Shader" );
	//m_BrushMenu.AddMenuItem( 7, "Mapping\nPlanar X");
	//m_BrushMenu.AddMenuItem( 8, "Mapping\nPlanar Y");
	//m_BrushMenu.AddMenuItem( 6, "Mapping\nPlanar Z");
	//m_BrushMenu.AddMenuItem( 9, "Mapping\nPlanar Auto");
	m_BrushMenu.AddMenuItem( BM_SNAP_TO_GRID, "Snap To Grid" );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
	m_BrushMenu.AddMenuItem( BM_CSG_HOLLOW, "Hollow..." );
	m_BrushMenu.AddMenuItem( BM_CSG_CARVE, "Carve" );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
#if 0
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_NODRAW, "Brush Filter\nNo Draw", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_SOLID, "Brush Filter\nSolid", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_WINDOW, "Brush Filter\nWindow", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_WATER, "Brush Filter\nWater", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_AREAPORTAL, "Brush Filter\nAreaportal", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_DETAIL, "Brush Filter\nDetail", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_NOSHADOW, "Brush Filter\nNo Shadow", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_ALWAYSSHADOW, "Brush Filter\nAlways Shadow", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_MONSTECLIP, "Brush Filter\nMonster Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_PLAYERCLIP, "Brush Filter\nPlayer Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_CAMERACLIP, "Brush Filter\nCamera Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_CORONABLOCK, "Brush Filter\nCorona Block", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_SKYBOX, "Brush Filter\nSky Box", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_SKYPORTAL, "Brush Filter\nSky Portal", true );
	m_BrushMenu.AddMenuItem( 0, "Brush Filter\n@SEP@" );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_FILTERALL, "Brush Filter\nFilter All", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_FILTERNONE, "Brush Filter\nFilter None", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_FILTERALLCLIP, "Brush Filter\nFilter All Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_FILTERALLSKY, "Brush Filter\nFilter All Sky", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_BRUSHFILTER_REAPPLYFILTER, "Brush Filter\nRe-Apply Filter", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_NODRAW, "Select Brushes By Attributes\nNo Draw", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_SOLID, "Select Brushes By Attributes\nSolid", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_WINDOW, "Select Brushes By Attributes\nWindow", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_WATER, "Select Brushes By Attributes\nWater", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_AREAPORTAL, "Select Brushes By Attributes\nAreaportal", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_DETAIL, "Select Brushes By Attributes\nDetail", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_NOSHADOW, "Select Brushes By Attributes\nNo Shadow", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_ALWAYSSHADOW, "Select Brushes By Attributes\nAlways Shadow", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_MONSTERCLIP, "Select Brushes By Attributes\nMonster Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_PLAYERCLIP, "Select Brushes By Attributes\nPlayer Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_CAMERACLIP, "Select Brushes By Attributes\nCamera Clip", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_CORONABLOCK, "Select Brushes By Attributes\nCorona Block", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_SKYBOX, "Select Brushes By Attributes\nSky Box", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTBRUSHESBYATTRIBUTES_SKYPORTAL, "Select Brushes By Attributes\nSky Portal", true );
#endif
	m_BrushMenu.AddMenuItem( BM_SELECT_BRUSHES_WITH_SAME_CONTENTS, "Select Brushes With Same Contents" );
	m_BrushMenu.AddMenuItem( BM_SELECT_BRUSHES_WITH_SAME_SURFACE, "Select Brushes With Same Surface Values" );

	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
	m_BrushMenu.AddMenuItem( ID_TOOLS_CHECKSELECTEDOBJECTS, "Check Selected Objects For Errors...", true );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );

	//
	// add link to entity objects.
	//
	CLinkedList<CEntDef>* entdefs = doc->GameDef()->EntDefList();
	CEntDef* def;
	int id = BM_FIRST_LINK_TO_ENTITY_MENU;

	for( def = entdefs->ResetPos(); def; def = entdefs->GetNextItem() )
	{
		if( def->IsOwner() && !def->IsBaseClass() )
		{
			CString s;

			s.Format( "Link To Entity\n%s", def->GetTreeDisplayName());
			m_BrushMenu.AddMenuItem( id++, s );
		}
	}

	m_BrushMenu.AddMenuItem( BM_UNLINK_FROM_ENTITY, "Unlink From Entity" );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
	m_BrushMenu.AddMenuItem( ID_TOOLS_HIDE, "Hide Selected", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SHOWALL, "Show All", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_HIDEALL, "Hide All" , true );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
	m_BrushMenu.AddMenuItem( ID_TOOLS_MAKEGROUP, "Make Group", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_MAKEGROUPANDHIDE, "Make Group and Hide", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_HIDEALLINGROUP, "Hide All In Group(s)", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SHOWALLINGROUPS, "Show All In Group(s)", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_SELECTALLINGROUPS, "Select All In Group(s)", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_REMOVEFROMGROUPS, "Remove From Group(s)", true );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
	m_BrushMenu.AddMenuItem( ID_TOOLS_FLIPVERTICAL, "Flip Vertical", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_FLIPHORIZONTAL, "Flip Horizontal", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_FLIPONXAXIS, "Flip On X Axis", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_FLIPONYAXIS, "Flip On Y Axis", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_FLIPONZAXIS, "Flip On Z Axis", true );
	m_BrushMenu.AddMenuItem( 0, "@SEP@" );
	m_BrushMenu.AddMenuItem( ID_TOOLS_ROTATE90CW, "Rotate 90 CW", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_ROTATE90CCW, "Rotate 90 CCW", true );
	m_BrushMenu.AddMenuItem( ID_TOOLS_ROTATE180, "Rotate 180", true );

	m_BrushMenuCreated = true;
}